<?php
defined('ABSPATH') || exit;
$shop_page_id = get_option('woocommerce_shop_page_id');
get_header();
?>
<main>
	<div class="wrapper_main">
		<div class="container">
			<div class="wrapper_content">
				<div class="title_wrapper">
					<div>
						<div class="icon_title">
							<?php include locate_template('assets/img/tales_icon_4.svg'); ?>
						</div>
						<h2 class="title"><?php echo woocommerce_page_title() ?></h2>
					</div>
					<?php get_template_part('template-parts/back', 'button') ?>
				</div>
				<div class="content_box">
					<div class="sub_title low">
						<?php the_field('subtitle', $shop_page_id) ?>
					</div>


					<div class="posts posts_shop">
						<div class="row">

							<?php

							if (woocommerce_product_loop()) {

								/**
								 * Hook: woocommerce_before_shop_loop.
								 *
								 * @hooked woocommerce_output_all_notices - 10
								 * @hooked woocommerce_result_count - 20
								 * @hooked woocommerce_catalog_ordering - 30
								 */
								// do_action('woocommerce_before_shop_loop');

								// woocommerce_product_loop_start();

								if (wc_get_loop_prop('total')) {
									while (have_posts()) {
										the_post();

										/**
										 * Hook: woocommerce_shop_loop.
										 */
										do_action('woocommerce_shop_loop');

										wc_get_template_part('content', 'product');
									}
								}

								// woocommerce_product_loop_end();

								/**
								 * Hook: woocommerce_after_shop_loop.
								 *
								 * @hooked woocommerce_pagination - 10
								 */
								// do_action('woocommerce_after_shop_loop');
							} else {
								/**
								 * Hook: woocommerce_no_products_found.
								 *
								 * @hooked wc_no_products_found - 10
								 */
								do_action('woocommerce_no_products_found');
							}
							?>
						</div>
					</div>
					<?php get_template_part('template-parts/member', 'card') ?>
				</div>
				<?php get_sidebar() ?>
			</div>
		</div>
	</div>

</main>
<?php get_footer(); ?>